//
//  TransactionAmountAndPurposeViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 22.02.23.
//

import UIKit
import JNGradientLabel

class TransactionAmountViewController : UIViewController, UITextFieldDelegate {

    
    @IBOutlet var topBarLabel: JNGradientLabel!
    
    
    @IBOutlet var textField: UITextField!

    @IBOutlet var amountGiroLabel: UILabel!
    
    
    @IBOutlet var lineLabel: UILabel!
    
    @IBOutlet var continueButton: UIButton!
    @IBOutlet var backButton: UIButton!
    
    @IBOutlet var balanceStackView: UIStackView!
    
    fileprivate var keyBoardHeight : Int = 0
    fileprivate var _kbSize:CGSize!
    
    fileprivate var sumGiroAccount : Float = 0.00
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        textField.becomeFirstResponder()
        textField.keyboardType = .decimalPad
        //  Registering for keyboard notification.
         NotificationCenter.default.addObserver(self, selector: #selector(self.keyboardWillShow(_:)), name: UIResponder.keyboardWillShowNotification, object: nil)
        // Change cursor color
        textField.tintColor = UIColor(red: 31/255, green: 98/255, blue: 152/255, alpha: 1.0)
        
        // change button text if we returned from summary navigation controller, i.e., user wants to change a single field
        if(returnedFromTransactionSummaryView == true) {
            continueButton.setTitle("Übernehmen", for: .normal)
            backButton.isHidden = true
        }
        
        // if user already entered transaction amount...
        if transactionAmountPublic != "" {
            textField.text = transactionAmountPublic
            Utilities.styleFilledButtonAuthScreenGreenEdged(continueButton)
            continueButton.isEnabled = true
            continueButton.isUserInteractionEnabled = true
        } else {
            // style continue button
            Utilities.styleFilledButtonLightGreyEdged(continueButton)
            continueButton.translatesAutoresizingMaskIntoConstraints = false
            continueButton.isUserInteractionEnabled = false
            continueButton.isEnabled = false
        }

        var amountGiroAccountString : String = ""
        let defaults = UserDefaults.standard
        if defaults.object(forKey: "amountGiroAccount") != nil {
            let amountGiroAccountAfterTransaction = defaults.float(forKey: "amountGiroAccount")
            //sumGiroAccount = amountGiroAccountPublic-userTransactionAmountDouble
            sumGiroAccount = amountGiroAccountAfterTransaction
            print("amountGiroAccountPublic:")
            print(amountGiroAccountPublic)
            print("userTransactionAmountDouble:")
            print(amountGiroAccountAfterTransaction)
            
        } else { // User transaction done
            sumGiroAccount = amountGiroAccountPublic
        }
        
        let giroLimit = Float(self.textField.text?.replacingOccurrences(of: ",", with: ".") ?? "0") ?? 0.00
        
        if(transactionAmountPublic != "" && giroLimit >= sumGiroAccount) {
            print("Not enough money.")
            textField.textColor = UIColor(red: 120.0/255.0, green: 22/255.0, blue: 13/255.0, alpha: 1.0)
            continueButton.isUserInteractionEnabled = false
            continueButton.isEnabled = false
            Utilities.styleFilledButtonLightGreyEdged(continueButton)
        }
        
        
        
        
        // top bar gradient color
        let gradientColors: [UIColor]    = [UIColor(red: 47.0/255.0, green: 67.0/255.0, blue: 99.0/255.0, alpha: 1.0), UIColor(red: 67/255.0, green: 114.0/255.0, blue: 196.0/255.0, alpha: 1.0)]
        let gradientlocations: [CGFloat] = [1.0, 0.0]
        
        topBarLabel.textColor = .white
        topBarLabel.textGradientLocation = .background
        topBarLabel.setAxialGradientParameters(startPoint: CGPoint(x: 0.0, y: 0.0),
                                                                endPoint: CGPoint(x: 1.0, y: 1.0),
                                                                colors: gradientColors,
                                                                locations: gradientlocations)
        
        // required for character counter
        textField.borderStyle = .none
        textField.textAlignment = .center
        textField.delegate = self
        textField.addTarget(self, action: #selector(self.textFieldDidChange(textField:)), for: UIControl.Event.editingChanged)
        

        
        amountGiroAccountString = String(format: "%.2f", sumGiroAccount).replacingOccurrences(of: ".", with: ",") + " €"
        
        Utilities.addDotsToBankBalance(sumFloat: sumGiroAccount ,sumString: &amountGiroAccountString)

        
        let accountGiroAmountStringAttributes = NSMutableAttributedString.init(string: amountGiroAccountString + "")
        
        accountGiroAmountStringAttributes.setAttributes([NSAttributedString.Key.font: UIFont.systemFont(ofSize: 18, weight: .light),
                                                         NSAttributedString.Key.foregroundColor: UIColor.darkGray],
                                              range: NSMakeRange(0, amountGiroAccountString.count))
        
        amountGiroLabel.attributedText = accountGiroAmountStringAttributes
        amountGiroLabel.font = UIFont.systemFont(ofSize: 18, weight: .light)
        amountGiroLabel.textColor = .darkGray
        
        // center balance stack view *horizontally* in view
        balanceStackView.translatesAutoresizingMaskIntoConstraints = false
        balanceStackView.centerXAnchor.constraint(equalTo: view.centerXAnchor).isActive = true

        lineLabel.translatesAutoresizingMaskIntoConstraints = false

        

     }



    @IBAction func backButton(_ sender: Any) {
        let giroLimit = Float(self.textField.text?.replacingOccurrences(of: ",", with: ".") ?? "0") ?? 0.00
        if(giroLimit >= sumGiroAccount) {
            print("Not enough money.")
            transactionAmountPublic = ""
            
        } else {
            let regex = try! NSRegularExpression(pattern: "^\\d+(,\\d+)?$")
            
            let string = self.textField.text ?? ""
            let range = NSRange(location: 0, length: string.utf16.count)
            let match = regex.firstMatch(in: string, options: [], range: range)

            if match != nil {
                print("String passt zum regulären Ausdruck")
                // Regulärer Ausdruck für ein Komma gefolgt von einer oder keinen Ziffern
                let regex = #",\d{1}$"#
                var stringTest : String = textField.text ?? ""
                if let range = stringTest.range(of: regex, options: .regularExpression) {
                    print("Der reguläre Ausdruck wurde im Bereich \(range) gefunden.")
                    stringTest += "0"
                }
                transactionAmountPublic = stringTest
            } else {
                print("String passt nicht zum regulären Ausdruck")
                transactionAmountPublic = ""
            }
        }
        
        let nc = self.storyboard?.instantiateViewController(withIdentifier: "TransactionRecipientNC") as! UINavigationController
        
        nc.modalPresentationStyle = .fullScreen
        nc.modalTransitionStyle = .crossDissolve
        present(nc, animated: true)
    }
    
    @IBAction func continueButton(_ sender: Any) {
        
        // Regulärer Ausdruck für ein Komma gefolgt von einer oder keinen Ziffern
        let regex = #",\d{1}$"#
        
        var stringTest : String = textField.text ?? ""
        //if stringTest.contains(",") {
        //}
        
        if let range = stringTest.range(of: regex, options: .regularExpression) {
            print("Der reguläre Ausdruck wurde im Bereich \(range) gefunden.")
            stringTest += "0"
        }
            
        
        transactionAmountPublic = stringTest
        
        if(returnedFromTransactionSummaryView == true) {
            let nc = self.storyboard?.instantiateViewController(withIdentifier: "TransactionSummaryNC") as! UIViewController
            
            nc.modalPresentationStyle = .popover
            nc.modalTransitionStyle = .coverVertical
            
            present(nc, animated: true)
        } else {
            let nc = self.storyboard?.instantiateViewController(withIdentifier: "TransactionPurposeNC") as! UINavigationController
            
            nc.modalPresentationStyle = .fullScreen
            nc.modalTransitionStyle = .crossDissolve
            present(nc, animated: true)
        }
        
    }
    
    
     /*  UIKeyboardWillShowNotification. */
         @objc internal func keyboardWillShow(_ notification : Notification?) -> Void {
             
             
             
             if let info = notification?.userInfo {

                 let frameEndUserInfoKey = UIResponder.keyboardFrameEndUserInfoKey
                 
                 //  Getting UIKeyboardSize.
                 if let kbFrame = info[frameEndUserInfoKey] as? CGRect {
                     
                     let screenSize = UIScreen.main.bounds
                     
                     //Calculating actual keyboard displayed size, keyboard frame may be different when hardware keyboard is attached (Bug ID: #469) (Bug ID: #381)
                     let intersectRect = kbFrame.intersection(screenSize)
                     
                     if intersectRect.isNull {
                         _kbSize = CGSize(width: screenSize.size.width, height: 350) // default keyboard height = 350
                     } else {
                         _kbSize = intersectRect.size
                     }
                     print("Your Keyboard Size \(_kbSize)")
                     print(_kbSize.height)
                     //let rectCG = CGRect(x: 0, y: 0, width: 0, height: _kbSize.height)
                     continueButton.bottomAnchor.constraint(equalTo: view.bottomAnchor, constant: -(_kbSize.height)-10).isActive = true
                     
                     balanceStackView.bottomAnchor.constraint(equalTo: view.bottomAnchor, constant: -(_kbSize.height)-55-20).isActive = true
                     
                     lineLabel.bottomAnchor.constraint(equalTo: view.bottomAnchor, constant: -(_kbSize.height)-55-45).isActive = true
                 }
             }
         }

    
    // https://stackoverflow.com/questions/30656501/how-to-do-a-live-uitextfield-count-while-typing-swift
    @objc func textFieldDidChange(textField : UITextField){
        
        let giroLimit = Float(self.textField.text?.replacingOccurrences(of: ",", with: ".") ?? "0") ?? 0.00
        if(giroLimit >= sumGiroAccount) {
            print("Not enough money.")
            textField.textColor = UIColor(red: 120.0/255.0, green: 22/255.0, blue: 13/255.0, alpha: 1.0)
            continueButton.isUserInteractionEnabled = false
            continueButton.isEnabled = false
            Utilities.styleFilledButtonLightGreyEdged(continueButton)
            
        } else if (sumGiroAccount == 0) {
            print("Zero € is not allowed.")
            
            textField.textColor = UIColor(red: 120.0/255.0, green: 22/255.0, blue: 13/255.0, alpha: 1.0)
            continueButton.isUserInteractionEnabled = false
            continueButton.isEnabled = false
            Utilities.styleFilledButtonLightGreyEdged(continueButton)
            
        } else {
            textField.textColor = UIColor(red: 30/255.0, green: 91/255.0, blue: 158/255.0, alpha: 1.0)
            
            
            let regex = try! NSRegularExpression(pattern: "^\\d+([.,]\\d+)?$") // "^\\d+(,\\d+)?$"
            
            let string = self.textField.text ?? ""
            let range = NSRange(location: 0, length: string.utf16.count)
            let match = regex.firstMatch(in: string, options: [], range: range)

            if match != nil {
                print("String passt zum regulären Ausdruck")
                continueButton.isUserInteractionEnabled = true
                continueButton.isEnabled = true
                Utilities.styleFilledButtonAuthScreenGreenEdged(continueButton)
            } else {
                print("String passt nicht zum regulären Ausdruck")
                continueButton.isUserInteractionEnabled = false
                continueButton.isEnabled = false
                Utilities.styleFilledButtonLightGreyEdged(continueButton)
            }
        }
      }


    
    func textField(_ textField: UITextField, shouldChangeCharactersIn range: NSRange, replacementString string: String) -> Bool {
        guard let text = textField.text, let decimalSeparator = Locale.current.decimalSeparator else {
            return true
        }
        
        var splitText = text.components(separatedBy: decimalSeparator)
        let totalDecimalSeparators = splitText.count - 1
        let isEditingEnd = (text.count - 3) < range.lowerBound
        
        print(textField.text ?? "")
        
        splitText.removeFirst()
        
        // Check if we will exceed 2 dp
        if splitText.last?.count ?? 0 > 1 && string.count != 0 && isEditingEnd {
            return false
        }
        
        // If there is already a dot or comma, we don't want to allow further dots or commas
        if totalDecimalSeparators > 0 && (string == decimalSeparator || string == ",") {
            return false
        }
        
        // Check if the first character is a dot or comma
        if (range.lowerBound == 0 && (string == decimalSeparator || string == ",")) {
            return false
        }
        
        // Attempt to read the range they are trying to change, or exit if we can't
        guard let stringRange = Range(range, in: text) else { return false }
        // Add their new text to the existing text
        let updatedText = text.replacingCharacters(in: stringRange, with: string)
        if updatedText.count >= 9 {
            return false
        }
        
        // Only allow numbers, comma, and decimal separator
        switch(string) {
        case "", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", decimalSeparator, ",":
            return true
        default:
            return false
        }
    }
}


extension String {
    var toDouble: Double {
        return Double(self) ?? 0.0
    }
}


extension String {
    func numberOfOccurrencesOf(string: String) -> Int {
        return self.components(separatedBy:string).count - 1
    }
}
